package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.GroupTask;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.biz.ResearchStudy;
import gov.va.vinci.dart.biz.Task;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestGroupTaskDAO extends BusinessIntegrationTest {
	
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testTwo() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findByName("DNS");
		
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);

		Group group = (Group)pers.getGroups().iterator().next();
		Assert.assertNotNull(group);

		try {
			GroupTask.create(null, null, group, "testing", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), null, "testing", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), group, null, "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), group, "", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), group, "1234567890123456789012345678901234567890123456789012345678901234567890", "testing","DNS");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing",null);
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		try {
			GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","123456789012345678901234567890123456789012345678901234567890");
			Assert.fail("Expected ValidationException");
		} catch (ValidationException e) {}

		GroupTask task = GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		Assert.assertTrue(task.getId() > 0);
		
		// test if we can find that task again
		Task task2 = DartObjectFactory.getInstance().getTaskDAO().findById(task.getId());
		Assert.assertNotNull(task2);
	}


	@Test
	public void testThree() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);

		Group group = (Group)pers.getGroups().iterator().next();
		Assert.assertNotNull(group);

		List<GroupTask> tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		GroupTask task = GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(group.getId());
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		// check to see if our new task is in the list
		boolean foundit = false;
		for (Task tt : tlist) {
			if (tt != null && tt.getId() == task.getId()) {
				foundit = true;
			}
		}
		
		Assert.assertTrue(foundit);
	}

	@Test
	public void testFour() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);

		Group group = (Group)pers.getGroups().iterator().next();
		Assert.assertNotNull(group);

		List<GroupTask> tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		GroupTask task = GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listOpenByOwner(group.getId());
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		// check to see if our new task is in the list
		Assert.assertTrue(tlist.contains(task));
	}

	@Test
	public void testFive() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);

		Group group = (Group)pers.getGroups().iterator().next();
		Assert.assertNotNull(group);

		List<GroupTask> tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		int requestId = rs.getFirstRequest().getId();
		Assert.assertTrue(requestId > 0);
		
		GroupTask task = GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listOpenByOwnerAndRequestId(group.getId(), requestId);
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		// check to see if our new task is in the list
		Assert.assertTrue(tlist.contains(task));
		
		// test the reverse - a silly request id is not found
		tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listOpenByOwnerAndRequestId(group.getId(), -1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);

	}

	@Test
	public void testSix() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);

		Group group = (Group)pers.getGroups().iterator().next();
		Assert.assertNotNull(group);

		List<GroupTask> tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		GroupTask task = GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listAllGroupTasks();
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		// check to see if our new task is in the list
		Assert.assertTrue(tlist.contains(task));
	}


	@Test
	public void testSeven() throws Exception {
		ResearchStudy rs = DartObjectFactory.getInstance().getResearchStudyDAO().findById(1);
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(rs);
		Assert.assertNotNull(pers);

		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);

		Group group = (Group)pers.getGroups().iterator().next();
		Assert.assertNotNull(group);

		List<GroupTask> tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listByOwner(-1);
		Assert.assertNotNull(tlist);
		Assert.assertFalse(tlist.size() > 0);
		
		GroupTask task = GroupTask.create(null, rs.getFirstRequest(), group, "testing", "testing","DNS");
		Assert.assertNotNull(task);
		Assert.assertNotNull(task.getName());
		Assert.assertNotNull(task.getCreatedBy());
		Assert.assertNotNull(task.getCreatedOn());
		
		tlist = DartObjectFactory.getInstance().getGroupTaskDAO().listAllOpenGroupTasks();
		Assert.assertNotNull(tlist);
		Assert.assertTrue(tlist.size() > 0);

		// check to see if our new task is in the list
		Assert.assertTrue(tlist.contains(task));
	}

}
